#version 430

layout (location = 0) in vec3 VertexPosition;
layout (location = 1) in vec2 TextureCoords;
layout (location = 2) in vec3 VertexNormal;
layout (location = 3) in vec3 Tangent;
layout (location = 4) in vec3 Bitangent;

uniform vec3 viewPos;
uniform vec3 LightPosition;				// Light position in eye view

out vec2 TexCoords;
out vec3 tanVert;
out vec3 tanView;
out vec3 tanLight;

out vec3 VertPos; //Vertex position in eye coords
out vec4 ViewSpaceVertPos; // vertex pos in view coords
out vec3 N; //Transformed normal

uniform mat4 NormalMatrix;
uniform mat4 M;
uniform mat4 V;
uniform mat4 MV;
uniform mat4 MVP;

void main()
{
	VertPos = vec3(M * vec4(VertexPosition, 1.0)); 
	ViewSpaceVertPos = MV * (vec4(VertexPosition, 1.0));
    TexCoords = TextureCoords;
    
	mat3 NormMatrix = transpose(inverse(mat3(M)));
    vec3 T = normalize(NormMatrix * vec3(Tangent));
    vec3 B = normalize(NormMatrix * Bitangent);
    vec3 N = normalize(NormMatrix * VertexNormal); 
    
    mat3 TBN = transpose(mat3(T, B, N));

	tanLight = TBN * LightPosition;
	tanView = TBN * viewPos;
	tanVert = TBN * VertPos;
    
    gl_Position = MVP * vec4(VertexPosition,1.0);
}
